/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.managed;

import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class UIObjectsFilter {
    private static ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();

    public static Set getAllowedShortIds(ShortObjectIdManager shortIdManager) {
        return UIObjectsFilter.getAllowedIds(shortIdManager, true);
    }

    public static Set getAllowedObjectIds(ShortObjectIdManager shortIdManager) {
        return UIObjectsFilter.getAllowedIds(shortIdManager, false);
    }

    public static boolean isObjectAllowed(ObjectId objectId, UserContext uc) {
        return mom.isObjectAllowed(objectId, uc);
    }

    public static Set getAllowedShortIds(Collection shortIds, UserContext uc, ShortObjectIdManager shortIdManager) {
        HashSet<String> result = new HashSet<String>();
        Iterator iterator = shortIds.iterator();
        while (iterator.hasNext()) {
            String shortId = (String)iterator.next();
            ObjectId objectId = shortIdManager.getObjectId(shortId);
            if (!mom.isObjectAllowed(objectId, uc)) continue;
            result.add(shortId);
        }
        return result;
    }

    private static Set getAllowedIds(ShortObjectIdManager shortIdManager, boolean shortIds) {
        HashSet<Object> result = new HashSet<Object>();
        Set objectIds = shortIdManager.getObjectIds();
        Iterator iterator = objectIds.iterator();
        while (iterator.hasNext()) {
            ObjectId next = (ObjectId)iterator.next();
            if (!mom.isObjectAllowed(next)) continue;
            if (shortIds) {
                result.add(shortIdManager.getShortId(next));
                continue;
            }
            result.add(next);
        }
        return result;
    }
}

